<?php
date_default_timezone_set("Asia/Jakarta");
header("Content-type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

$lokasi = $_SERVER['DOCUMENT_ROOT'];

include $lokasi.'/db.php';
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['kode'])) {
    if ($data['kode'] == "Elemch Sukses" && $data['menu'] == "kelas"){
        $sendESP = $conn->query("SELECT
                            kelas.id,
                            kelas.id_kelas,
                            kelas.jam_mulai,
                            kelas.jam_selesai,
                            kelas.hari,
                                d1.nama AS dosen1, 
                                d2.nama AS dosen2, 
                                mk.mata_kuliah 
                            FROM kelas
                            LEFT JOIN dosen AS d1 ON kelas.dosenP1 = d1.id
                            LEFT JOIN dosen AS d2 ON kelas.dosenP2 = d2.id
                            LEFT JOIN mata_kuliah AS mk ON kelas.mata_kuliah = mk.id;")->fetch_all(MYSQLI_ASSOC);
        $dataArray = [];
        foreach ($sendESP as $row) {
            $dataArray[] = [
                "kolomID" => $row['id'],
                "kolom1" => $row['id_kelas'],
                "kolom2" => $row['mata_kuliah'],
                "kolom3" => trim($row['dosen1'] . " | " . $row['dosen2'], "|"), // Menghapus separator berlebih
                "kolom4" => $row['hari'],
                "kolom5" => $row['jam_mulai'],
                "kolom6" => $row['jam_selesai']
            ];
        }
                            
        if ($sendESP) echo json_encode(["status" => "success", "data" => $dataArray]); 
        else echo json_encode(["message" => "id_kelas tidak ditemukan"]);
    }
    
    else if ($data['kode'] == "Elemch Sukses" && $data['menu'] == "matakuliah"){
        $sendESP = $conn->query("SELECT * FROM `mata_kuliah`;")->fetch_all(MYSQLI_ASSOC);
        $dataArray = [];
        foreach ($sendESP as $row) {
            $dataArray[] = [
                "kolomID" => $row['id'],
                "kolom1" => $row['mata_kuliah'],
                "kolom2" => $row['semester'],
                "kolom3" => $row['sks']
            ];
        }
                            
        if ($sendESP) echo json_encode(["status" => "success", "data" => $dataArray]); 
        else echo json_encode(["message" => "id_kelas tidak ditemukan"]);
    }
    
    else if ($data['kode'] == "Elemch Sukses" && $data['menu'] == "dosen"){
        $sendESP = $conn->query("SELECT * FROM `dosen`;")->fetch_all(MYSQLI_ASSOC);
        $dataArray = [];
        foreach ($sendESP as $row) {
            $dataArray[] = [
                "kolomID" => $row['id'],
                "kolom1" => $row['nama'],
                "kolom2" => $row['alamat']
            ];
        }
                            
        if ($sendESP) echo json_encode(["status" => "success", "data" => $dataArray]); 
        else echo json_encode(["message" => "id_kelas tidak ditemukan"]);
    }
    
    else if ($data['kode'] == "Elemch Sukses" && $data['menu'] == "device"){
        $sendESP = $conn->query("SELECT * FROM `device`;")->fetch_all(MYSQLI_ASSOC);
        $dataArray = [];
        foreach ($sendESP as $row) {
            $dataArray[] = [
                "kolomID" => $row['id'],
                "kolom1" => $row['id_device'],
                "kolom2" => $row['namaClass'],
                "kolom3" => $row['lokasi']
            ];
        }
                            
        if ($sendESP) echo json_encode(["status" => "success", "data" => $dataArray]); 
        else echo json_encode(["message" => "id_kelas tidak ditemukan"]);
    }
    
    
} else {
    echo json_encode(["message" => "id_kelas tidak ditemukan"]);
}

